<?php
get_header();
?>

<style>
    .chg-cat a {
  color: #08393785;
}
</style>

<div class="article-image">
<?php if ( get_field( 'image_slide' ) ) : ?>
	<img src="<?php the_field( 'image_slide' ); ?>" 
        width="100%" height="auto"/>
<?php endif ?>
 
    <div class="container">
        <section class="article-content">
            <div class="pad-content">
                <div class="holder-content">

                <div class="holder-title-search">
                    <div class="bloc-vert">
                        <?php the_terms(get_the_ID(), 'categorie_pub'); ?>
                    </div>
                    <div class="title-article">
                        <h1><?php the_title(); ?></h1>
                    </div>
                </div>
                    <div class="holder-social-article">
                        <ul class="social-icon-article">
                            <li><a href="<?php the_field( 'lien_linkedin' ); ?>"><i class="fa-brands fa-linkedin-in"></i></a></li>
                            <li><a href="<?php the_field( 'lien_fb' ); ?>"><i class="fa-brands fa-facebook-f" aria-hidden="true"></i></a></li>
                            <li><a href="<?php the_field( 'lien_twitter' ); ?>"><i class="fa-brands fa-x-twitter"></i></a></li>
                        </ul>
                    </div>

                </div>
                <div class="desc-article">
                <?php the_content(); ?>
                     <div class="title-desc">Description succincte du projet</div>
                    <div class="desc-content">
                        Designation : L’hydrogène vert pour une croissance durable et une économie à faibles
                        émissions de carbone en Tunisie (H2vert.TUN)
                        <br>
                        Commettant : Ministère fédéral allemand de la Coopération économique et du Développement
                        (BMZ)
                        <br>
                        Pays : Tunisie​​​​​​​
                        <br>
                        Partenaire : Ministère de l’Industrie, des Mines et de l’Énergie (MIME)​​​​​​​
                        <br>
                        Organisme de tutelle : Ministère de l’Industrie, des Mines et de l’Énergie (MIME)​​​​​​​
                        <br>
                        Durée totale : De 2022 à 2025
                    </div>
                    <div class="title-desc">Situation initiale</div>
                    <div class="desc-content">
                        Au regard de ses vastes ressources solaires et éoliennes, la Tunisie dispose d’un fort
                        potentiel en matière de production d’électricité à partir d’énergies renouvelables. En
                        outre, avec le Plan solaire, le gouvernement tunisien s’engage à les développer. L’objectif
                        est de produire 30 % d’électricité à partir d’installations photovoltaïques et éoliennes
                        d’ici 2030.
                        <br> <br>
                        En Tunisie, les conditions nécessaires à la production d’hydrogène vert et de ses produits
                        dérivés (Power-to-X, P2X) sont donc réunies. Le gouvernement souhaite se positionner en tant
                        qu’acteur important de ce secteur. Malgré la volonté politique et les potentiels présentés,
                        la Tunisie n’est toutefois jusqu’à présent pas encore suffisamment préparée à développer une
                        économie de l’hydrogène.
                    </div>
                    <div class="title-desc">Objectif</div>
                    <div class="desc-content">
                        Les conditions règlementaires, techniques et professionnelles de la Tunisie sont améliorées
                        afin de créer une filière de l’hydrogène vert et de ses produits dérivés.


                    </div>
                    <div class="title-desc">Approche</div>
                    <div class="desc-content">
                        Le projet soutient tout particulièrement le ministère de l’Industrie, des Mines et de
                        l’Énergie (MIME), lequel coordonne les acteurs nationaux et internationaux et dirige
                        l’échange interinstitutionnel sur l’hydrogène vert et le P2X. Le projet repose ici sur trois
                        piliers :
                        <br> <br>
                        - Il promeut une stratégie nationale de l’hydrogène et crée ainsi un cadre stratégique et
                        réglementaire, tout en améliorant les conditions politiques pour une économie de l’hydrogène
                        vert.
                        <br> <br>
                        - En outre, le projet optimise les conditions d’investissement du secteur privé en soutenant
                        la collaboration entre les entreprises locales et internationales. Il conseille également
                        l’Observatoire national des filières de l’hydrogène vert/du P2X et réalise des analyses
                        économiques ainsi que des études de concept.
                        <br> <br>
                        - Enfin, le projet renforce les compétences techniques des responsables politiques et
                        scientifiques. Les stratégies et concepts alors élaborés doivent aider les partenaires
                        tunisiens à gérer le développement d’un marché de l’hydrogène vert.



                    </div> 
                </div>
             
            </div>

        </section>

    </div>
</div>



<div class="height"></div>



<section class="contact-section-3">
    <div class="container">
        <div class="presentation">
            <div class="holder-title">
                <h2>Articles <strong style="color:#4E9F2E">similaires</strong></h2>
            </div>
        </div>
        <div class="owl-carousel contact-carousel">
            <?php
            // Get the current post's category
            $categories = get_the_terms(get_the_ID(), 'categorie_pub');
            $category_slugs = array();
            if (!empty($categories)) {
                foreach ($categories as $category) {
                    $category_slugs[] = $category->slug;
                }
            }

            // Query posts in the same category, excluding the current post
            $args = array(
                'post_type'      => 'puublications',
                'post_status'    => 'publish',
                'order'          => 'ASC',
                'posts_per_page' => -1, // retrieve all posts
                'post__not_in'   => array(get_the_ID()), // Exclude the current post
                'tax_query'      => array(
                    array(
                        'taxonomy' => 'categorie_pub',
                        'field'    => 'slug',
                        'terms'    => $category_slugs, // Filter by category
                    ),
                ),
            );

            $loop = new WP_Query($args);

            while ($loop->have_posts()) : $loop->the_post();
            ?>
            <div class="item">
                <div class="card">
                <?php if ( get_field( 'petite_image' ) ) : ?>
                    <img src="<?php the_field( 'petite_image' ); ?>" width="100%" class="card-img-top" />
                <?php endif ?>
                    <div class="card-body">
                        <div class="category"> 
                            <div class="chg-cat">
                            <?php the_terms(get_the_ID(), 'categorie_pub'); ?>
                            </div>
                           
                        </div>
                        <h5 class="card-title"><?php the_title() ?></h5>
                        <p class="card-text"><?php the_field('description'); ?> </p>
                        <a href="<?php the_permalink(); ?>" class="btn">Read all</a>
                    </div>
                </div>
            </div>
            <?php endwhile;
            wp_reset_query();
            ?>
        </div>
    </div>
</section>












<?php 

get_footer();