<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

?>
</main><!-- #main -->
</div><!-- #primary -->
</div><!-- #content -->

<!------- End Page Content ------->
<!------- Begin Footer------->
<footer class="footer">
    <div class="container-fluid">
        <section class="bloc-investir">
            <div class="container">
                <div class="row">
                    <div class="col-md-6">
                        <h2>Vous cherchez</br> à investir ?</h2>
                        <p>Tenez-nous au courant et nous </br>prendrons contact avec vous dans</br> les plus brefs
                            délais.
                        </p>
                        <a href="<?php echo home_url()?>/investir" class="classic-btn">J’investis</a>
                    </div>
                    <div class="col-md-6">
                        <div class="bg-linear-investir">
                            <img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/image/Statistique (jp).svg"
                                alt="" width="100%">
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="newsletter">
            <div class="container">
                <div class="row">
                    <div class="col-md-6">
                        <h2>Abonnez-vous à </br> notre newsletter</h2>
                    </div>
                    <div class="col-md-6">
                        <form action="">
                            <input type="text" placeholder="Votre adresse e-mail" name="mail" required
                                class="form-news"  oninput="changeColor(this)">
                            <input type="submit" value="Subscribe" class="classic-btn">
                        </form>
                    </div>
                </div>
            </div>
        </section>

        <section class="footer-bottom">
            <div class="container">
                <div class="row">
                    <div class="col-md-8">
                        <img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/image/Groupe4875.svg"
                            alt="Logo h2vert">
                        <div class="company-info">
                            <p class="p-adress">Green Hydrogen Tunisia, l’énergie du futur</p>
                            <ul>
                                <li class="tel"><i class="fas fa-phone"></i> <a href="tel:21672548632">+ 216 72 548 632</a></li>
                                <li class="mail"><i class="fas fa-envelope"></i> <a href="mailto:info@h2vert.com">info@h2vert.com</a></li>
                            </ul>

                        </div>
                    </div>
                    <div class="col-md-2">
                        <ul class="list-footer">
                            <li><a href="<?php echo home_url()?>/faq">FAQ</a></li>
                            <li><a href="<?php echo home_url()?>/glossaire">Glossaire</a></li>
                            <li><a href="#">Work With US</a></li>
                            <li><a href="#">Terms & Conditions</a></li>
                            <li><a href="#">Press Enquiries</a></li>
                            <li><a href="#">Mentions légales</a></li>
                        </ul>
                    </div>
                    <div class="col-md-2">
                        <ul class="list-footer">
                            <li><a href="<?php echo home_url() ?>/a-propos">A propos</a></li>
                            <li><a href="<?php echo home_url() ?>/investir">Investir</a></li>
                            <li><a href="<?php echo home_url() ?>/actualites">Actualités</a></li>
                            <li><a href="<?php echo home_url() ?>/publications">Publications</a></li>
                            <li><a href="<?php echo home_url() ?>/ministere-tutelle">Ministère Tutelle</a></li>
                            <li><a href="#">Coopération Internationale</a></li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="copyright">
                <div class="container">
                <ul class="social-icon">
                    <li><a href=""><i class="fa-brands fa-x-twitter"></i></a></li>
                    <li><a href=""><i class="fa-brands fa-facebook-f"></i></a></li>
                    <li><a href="">GREEN H2 TUNISIA</a></li>
                </ul>
                <!-- <p>Green Hydrogen Tunisia,l’énergie du futur</p> -->
            </div>
            </div>
        </section>
    </div>
</footer>
<!------- Begin Footer ------->

</body>

<script src="<?php echo get_stylesheet_directory_uri(); ?>/assets/bootstrap-5/js/bootstrap.min.js"></script>
<script src="https://kit.fontawesome.com/24508cbe2c.js" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.0/jquery.min.js"
    integrity="sha512-3gJwYpMe3QewGELv8k/BX9vcqhryRdzRMxVfq6ngyWXwo03GFEzjsUm8Q7RZcHPHksttq7/GFoxjCVUjkjvPdw=="
    crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="<?php echo get_stylesheet_directory_uri(); ?>/assets/owlcarousel/owl.carousel.min.js"></script>
<script src="<?php echo get_stylesheet_directory_uri(); ?>/assets/js/main.js"></script>
<script>
    function changeColor(input) {
        input.style.color = "#296F4C"; // Change to whatever color you desire
    }
    
// jQuery('.category-link').on('click', function() {
//         jQuery('#category').val( jQuery(this).attr("data-category"));
// 		jQuery('#step').val(0);	
//         jQuery('#voir_plus').prop("disabled", true);
// 		$url_alaune = 'https://h2vert.evast-in.com/site/actualites-ajax/?step=' + jQuery('#step').val()+'&category=' + jQuery('#category').val();
// 		jQuery.ajax({
// 			url: $url_alaune,
// 			success: function(responsedata) {
// 				jQuery('#container_article').html(responsedata);
// 				jQuery('#step').val(parseInt(jQuery('#step').val()) + 1);
// 				jQuery('#voir_plus').prop("disabled", false);
// 			}
// 		});
// 	});
// jQuery('#voir_plus').on('click', function() {
// 		jQuery('#voir_plus').prop("disabled", true);
// 		$url_alaune = 'https://h2vert.evast-in.com/site/actualites-ajax/?step=' + jQuery('#step').val()+'&category=' + jQuery('#category').val();
// 		jQuery.ajax({
// 			url: $url_alaune,
// 			success: function(responsedata) {
// 				jQuery('#container_article').html(jQuery('#container_article').html() + responsedata);
// 				jQuery('#step').val(parseInt(jQuery('#step').val()) + 1);
// 				jQuery('#voir_plus').prop("disabled", false);
// 			}
// 		});
// 	});
jQuery(document).ready(function($) {
    // Function to load articles for all categories
    function loadAllArticles($posts_per_page) 
    {
        $('#step').val(1);
        $('#voir_plus').prop("disabled", true);
        var url = 'https://h2vert.evast-in.com/site/actualites-ajax/?step=' + $('#step').val()+'&posts_per_page='+$posts_per_page;
        $.ajax({
            url: url,
            success: function(responsedata) {
                $('#container_article').html(responsedata);
                $('#step').val(parseInt($('#step').val()) + 1);
                $('#voir_plus').prop("disabled", false);
            }
        });
    }
    var post_encours ='<?php echo get_the_ID() ?>';
    if(post_encours==7)
        loadAllArticles(5);
    if(post_encours==23)
        loadAllArticles(10);
    // Click event for category links
    $('.category-link').on('click', function() {
        $('#category').val($(this).attr("data-category"));
        $('#step').val(1);   
        $('#voir_plus').prop("disabled", true);
        var url = 'https://h2vert.evast-in.com/site/actualites-ajax/?step=' + $('#step').val()+'&category=' + $('#category').val();
        $.ajax({
            url: url,
            success: function(responsedata) {
                $('#container_article').html(responsedata);
                $('#step').val(parseInt($('#step').val()) + 1);
                $('#voir_plus').prop("disabled", false);
            }
        });
    });
    // Click event for "Voir plus" button
    $('#voir_plus').on('click', function() {
        $('#voir_plus').prop("disabled", true);
        var url = 'https://h2vert.evast-in.com/site/actualites-ajax/?step=' + $('#step').val()+'&category=' + $('#category').val();
        $.ajax({
            url: url,
            success: function(responsedata) {
                $('#container_article').html($('#container_article').html() + responsedata);
                $('#step').val(parseInt($('#step').val()) + 1);
                $('#voir_plus').prop("disabled", false);
            }
        });
    });
});




jQuery(document).ready(function($) {
    // Function to load articles for all categories
    function loadAllPublications(postsPerPage) {
        $('#step').val(1);
        $('#voir_plus').prop("disabled", true);
        var url = 'https://h2vert.evast-in.com/site/publications-ajax/?step=' + $('#step').val()+'&category=' + $('#category').val();
        $.ajax({
            url: url,
            success: function(responsedata) {
                $('#container_article').html(responsedata);
                $('#step').val(parseInt($('#step').val()) + 1);
                $('#voir_plus').prop("disabled", false);
            }
        });
    }

    // Check if the page is the publications page or a specific template
    var isPublicationsPage = <?php echo is_page_template('publications-ajax.php') ? 'true' : 'false'; ?>;
    if (isPublicationsPage) {
        loadAllPublications(10); // Assuming 10 publications per page for the publications page
    }

    // Click event for category links
    $('.category-link').on('click', function() {
        $('#category').val($(this).attr("data-category"));
        $('#step').val(1);
        $('#voir_plus').prop("disabled", true);
        var url = 'https://h2vert.evast-in.com/site/publications-ajax/?step=' + $('#step').val()+'&category=' + $('#category').val();
        $.ajax({
            url: url,
            success: function(responsedata) {
                $('#container_article').html(responsedata);
                $('#step').val(parseInt($('#step').val()) + 1);
                $('#voir_plus').prop("disabled", false);
            }
        });
    });

    // Click event for "Voir plus" button
    $('#voir_plus').on('click', function() {
        $('#voir_plus').prop("disabled", true);
        var url = 'https://h2vert.evast-in.com/site/publications-ajax/?step=' + $('#step').val()+'&category=' + $('#category').val();
        $.ajax({
            url: url,
            success: function(responsedata) {
                $('#container_article').html($('#container_article').html() + responsedata);
                $('#step').val(parseInt($('#step').val()) + 1);
                $('#voir_plus').prop("disabled", false);
            }
        });
    });
});

</script>
</div><!-- #page -->
<?php wp_footer(); ?>