$(".option").click(function(){
    $(".option").removeClass("active");
    $(this).addClass("active");
    
 });

 // home-slider carrousel 
 $('.slider-carousel').owlCarousel({
    loop:true,
    margin:10,
    dots:true,
    nav:false,
    autoplay: true, 
    autoplayTimeout: 4000, 
    responsiveClass:true,
    responsive:{
        0:{
            items:1,
        }
    }
})
$(document).ready(function() {
    var carousel = $(".slider-one-side");
    
    // Initialize Owl Carousel
    carousel.owlCarousel({
        loop: true, // Enable loop
        margin: 30,
        nav: false,
        dots: false,
        autoplay: true, // Enable autoplay
        autoplayTimeout: 1000, // Time between slides
        autoplayHoverPause: true, // Pause on hover
        responsive: {
            0: {
                items: 1 // Show 1 item for screens smaller than 600px
            },
            600: {
                items: 2 // Show 2 items for screens between 600px and 768px
            },
            768: {
                items: 3, // Show 3 items for screens larger than 768px
                loop: false, // Disable loop for larger screens
                autoplay: false // Disable autoplay for larger screens
            }
        }
    });

    // Start from the first slide
    carousel.trigger('to.owl.carousel', [0]);
});



 // Get the navigation menu element
var navbar = document.querySelector(".navbar");

// Get the offset position of the navigation menu
var sticky = navbar.offsetTop;

// Add the sticky class to the navigation menu when you reach its scroll position
function stickNavbar() {
    if (window.pageYOffset > sticky) {
        navbar.classList.add("sticky");
    } else {
        navbar.classList.remove("sticky");
    }
}

// When the user scrolls the page, execute stickNavbar
window.onscroll = function() {
    stickNavbar();
};
 

$('.contact-carousel').owlCarousel({
    loop: true,
    items: 3,
    margin: 20,
    dots: true,
    nav: false,
    responsiveClass: true,
    slideBy: 3, 
    autoplay: true, 
    autoplayTimeout: 4000, 
    responsive: {
        0: {
            items: 1, 
            slideBy: 1, 
            autoplay: true 
        },
        789: { 
            items: 3, 
            slideBy: 3 
        }
    }
});

 // Get all option elements
const options = document.querySelectorAll('.option');
const container = document.querySelector('.dark'); // Reference to the container

// Function to update option states
function updateOptions() {
    // Check if the window width is less than 786px
    if (window.innerWidth < 786) {
        container.classList.add('no-animation'); // Add class to disable animations
        options.forEach(opt => {
            opt.classList.remove('active'); // Remove active class
            const main = opt.querySelector('.main');
            const mainInactive = opt.querySelector('.main-inactive');
            main.style.display = 'none'; // Hide main content
            mainInactive.style.display = 'block'; // Show inactive content
        });
    } else {
        container.classList.remove('no-animation'); // Remove class to enable animations
    }
}

// Loop through each option
options.forEach(option => {
    option.addEventListener('click', function() {
        // Only allow toggling if the window width is 786px or wider
        if (window.innerWidth >= 786) {
            // Remove 'active' class from all options
            options.forEach(opt => opt.classList.remove('active'));

            // Add 'active' class to clicked option
            this.classList.add('active');

            // Hide/show .main content based on active state
            options.forEach(opt => {
                const main = opt.querySelector('.main');
                const mainInactive = opt.querySelector('.main-inactive');
                if (!opt.classList.contains('active')) {
                    main.style.display = 'none';
                    mainInactive.style.display = 'block';
                } else {
                    main.style.display = 'block';
                    mainInactive.style.display = 'none';
                }
            });
        }
    });
});

// Call updateOptions on load and on resize
updateOptions();
window.addEventListener('resize', updateOptions);



// Get the <p> element
var hydrogenText = document.querySelector('.colors-timeline .pad-vert p');

// Get all the <li> elements
var listItems = document.querySelectorAll('.colors-timeline ol li');

// Add event listener to each <li> element
listItems.forEach(function(item) {
    item.addEventListener('click', function() {
        // Get the color data attribute value of the selected option
        var selectedColor = this.querySelector('span').getAttribute('data-color');

        // Check if the selected color is white
        if (selectedColor === "#F7F7F7") {
            // Change the color of the <p> element to a different color
            hydrogenText.style.color = "#2a6550"; // Change this to your desired color
        } else {
            // Revert the color of the <p> element to its default color
            hydrogenText.style.color = ""; // Empty string for default color
        }
    });
});

// Remove smooth scrolling event listener for clicks on slides
document.querySelectorAll('.slide').forEach(item => {
    item.removeEventListener('click', event => {
        item.scrollIntoView({ behavior: 'smooth' });
    });
});

// Comment out or remove the rest of the code related to scrolling
/*
document.addEventListener("DOMContentLoaded", function() {
    const items = document.querySelectorAll('.slide-1 .col-md-6');
    items.forEach((item, index) => {
        setTimeout(() => {
            item.style.opacity = 1;
        }, index * 500);
    });
});

let scrollingSection = document.querySelector('.scrolling-sections');
let isScrolling = false;

function updateScroll() {
    if (isScrolling) {
        scrollingSection.scrollLeft += 1; // Adjust the scrolling speed as needed
    }
    requestAnimationFrame(updateScroll);
}

function startScrolling() {
    isScrolling = true;
}

function stopScrolling() {
    isScrolling = false;
}

// Start scrolling when user starts scrolling the page
window.addEventListener('scroll', startScrolling);

// Stop scrolling when user stops scrolling the page
window.addEventListener('scroll', stopScrolling);

// Initialize the scroll loop
updateScroll();
*/



document.addEventListener('DOMContentLoaded', function() {
    const dropdownToggle = document.getElementById('navbarDropdown50');
    const dropdownMenu = document.querySelector('.dropdown-menu');
    const redirectUrl = dropdownToggle.href; // Store the redirect URL

    // Toggle dropdown on click for mobile
    dropdownToggle.addEventListener('click', function(event) {
        event.preventDefault(); // Prevent the default link behavior
        dropdownMenu.classList.toggle('show'); // Toggle the dropdown visibility

        // Redirect after a delay
        setTimeout(() => {
            window.location.href = redirectUrl;
        }, 5000); // Change the delay time as needed (3000ms = 3 seconds)
    });

    // Close dropdown if clicked outside
    document.addEventListener('click', function(event) {
        if (!dropdownToggle.contains(event.target) && !dropdownMenu.contains(event.target)) {
            dropdownMenu.classList.remove('show');
        }
    });
});






function toggleAccordion(element) {
    const card = element.parentElement.parentElement; // Adjusted to go two levels up to the card container
    const content = card.querySelector('.card-content');
    const icon = card.querySelector('.icon');

    // Close all other cards
    const allCards = document.querySelectorAll('.card-1');
    allCards.forEach(cardItem => {
        if (cardItem !== card && cardItem.classList.contains('active')) {
            const cardContent = cardItem.querySelector('.card-content');
            const cardIcon = cardItem.querySelector('.icon');
            cardContent.style.display = 'none';
            cardIcon.style.transform = 'rotate(0deg)';
            cardItem.classList.remove('active');
        }
    });

    if (content.style.display === 'none') {
        content.style.display = 'block';
        icon.style.transform = 'rotate(180deg)';
        card.classList.add('active'); // Add active class to the clicked card
    } else {
        content.style.display = 'none';
        icon.style.transform = 'rotate(0deg)';
        card.classList.remove('active'); // Remove active class from the clicked card
    }
}

  


   $(".option").click(function () {
    $(".option").removeClass("active");
    $(this).addClass("active");

 });

document.addEventListener("DOMContentLoaded", function() {
    const list = document.querySelector("ol");
    const items = list.querySelectorAll("li");

    list.addEventListener("click", click);

    function click(e) {
        let target = e.target;
        if (target.nodeName === "SPAN") target = e.target.parentNode;

        if (target.nodeName !== "LI") return;

        items.forEach((item) => item.classList.remove("active"));
        target.classList.add("active");

        const leftImgSrc = target.querySelector("span").getAttribute("data-left-img");
        const rightImgSrc = target.querySelector("span").getAttribute("data-right-img");
        const timeline = document.querySelector(".timeline");

        // Set left and right images as background images
        timeline.style.setProperty('--left-img', `url('${leftImgSrc}')`);
        timeline.style.setProperty('--right-img', `url('${rightImgSrc}')`);

        const holder = document.querySelector(".pad-vert");
        const colorText = document.getElementById("color-text");

        // Change background color
        const color = target.querySelector("span").getAttribute("data-color");
        holder.style.backgroundColor = color;

        // Change text
        const text = target.querySelector("span").getAttribute("data-text");
        colorText.textContent = text;
    }

    // Trigger the click event on the start-timeline element
    document.querySelector(".start-timeline").click();
});



